/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceProperties;
import com.ibm.hwmca.fw.mediasvc.MediaServicesErrorIds;
import com.ibm.hwmca.fw.mediasvc.MediaServicesParameterKeys;
import com.ibm.hwmca.fw.mediasvc.MediaServicesParameters;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

class MediaProperties
implements MediaServicesErrorIds,
MediaServicesParameterKeys {
    private static final String TRACE_MASKT = "XMDAMDPT";
    private static final String TRACE_MASKF = "XMDAMDPF";
    private static final String TRACE_MASKD = "XMDAMDPD";
    private static final String DFSCRIPT = "media.df.script";
    private static final String LABEL_EXT = ".label";
    private String mountPoint;
    private String tempFile;
    private MediaServicesParameters mediaServicesParameters;
    private MediaDeviceProperties mediaDeviceProperties;

    MediaProperties(MediaDeviceProperties mediaDeviceProperties) {
        Trace.trace(TRACE_MASKT, "-> MediaProperties.MediaProperties(MediaDeviceProperties = " + mediaDeviceProperties + ")");
        this.mediaDeviceProperties = mediaDeviceProperties;
        this.mountPoint = mediaDeviceProperties.getMountPoint();
        int i = this.mountPoint.lastIndexOf(47);
        this.mediaServicesParameters = MediaServicesParameters.getMediaServicesParameters();
        this.tempFile = this.mediaServicesParameters.getParm("media.temp.dir") + this.mountPoint.substring(i + 1);
        Trace.trace(TRACE_MASKT, "<- MediaProperties.MediaProperties()");
    }

    String getFileSystemType() {
        Trace.trace(TRACE_MASKT, "-> MediaProperties.getFileSystemType()");
        this.invokeDf();
        Trace.trace(TRACE_MASKT, "<- MediaProperties.getFileSystemType()");
        return this.tokenizeDfOutput(2);
    }

    long getTotalSpace() {
        Trace.trace(TRACE_MASKT, "-> MediaProperties.getTotalSpace()");
        this.invokeDf();
        Trace.trace(TRACE_MASKT, "<- MediaProperties.getTotalSpace()");
        return Long.parseLong(this.tokenizeDfOutput(3));
    }

    long getUsedSpace() {
        Trace.trace(TRACE_MASKT, "-> MediaProperties.getUsedSpace()");
        this.invokeDf();
        Trace.trace(TRACE_MASKT, "<- MediaProperties.getUsedSpace()");
        return Long.parseLong(this.tokenizeDfOutput(4));
    }

    long getAvailableSpace() {
        Trace.trace(TRACE_MASKT, "-> MediaProperties.getAvailableSpace()");
        this.invokeDf();
        Trace.trace(TRACE_MASKT, "<- MediaProperties.getAvailableSpace()");
        return Long.parseLong(this.tokenizeDfOutput(5));
    }

    String getLabel(MediaDevice mediaDevice) throws MediaDeviceException {
        Trace.trace(TRACE_MASKT, "-> MediaProperties.getLabel(MediaDevice = " + mediaDevice + ")");
        String mediaLabel = null;
        String labelFile = this.tempFile + LABEL_EXT;
        try {
            String[] labelCmd = new String[5];
            labelCmd[0] = this.mediaDeviceProperties.getLabelScript();
            labelCmd[1] = this.mediaDeviceProperties.getDeviceFile();
            labelCmd[2] = labelFile;
            labelCmd[3] = this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log");
            int[] mediaSupported = this.mediaDeviceProperties.getMediaSupported();
            labelCmd[4] = " ";
            for (int i = 0; i < mediaSupported.length; ++i) {
                if (mediaSupported[i] != 1 && mediaSupported[i] != 8) continue;
                labelCmd[4] = this.mediaDeviceProperties.getDosDrive();
            }
            Trace.trace(TRACE_MASKF, "MediaProperties.getLabel(): labelCmd[0] = " + labelCmd[0]);
            Trace.trace(TRACE_MASKF, "MediaProperties.getLabel(): labelCmd[1] = " + labelCmd[1]);
            Trace.trace(TRACE_MASKF, "MediaProperties.getLabel(): labelCmd[2] = " + labelCmd[2]);
            Trace.trace(TRACE_MASKF, "MediaProperties.getLabel(): labelCmd[3] = " + labelCmd[3]);
            Trace.trace(TRACE_MASKF, "MediaProperties.getLabel(): labelCmd[4] = " + labelCmd[4]);
            int rc = RootProcess.executeProgram(labelCmd);
            Trace.trace(TRACE_MASKF, "MediaProperties.getLabel(): rc = " + rc);
            if (rc != 0) {
                throw new IOException("error occurred in the label script, return code of: " + rc);
            }
            mediaLabel = mediaDevice.readLabelFile(labelFile);
            Trace.trace(TRACE_MASKF, "MediaProperties.getLabel(): mediaLabel = " + mediaLabel);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 616, mdexc).log();
            throw mdexc;
        }
        Trace.trace(TRACE_MASKT, "<- MediaProperties.getLabel(): returns " + mediaLabel);
        return mediaLabel;
    }

    private String tokenizeDfOutput(int pos) {
        Trace.trace(TRACE_MASKT, "-> MediaProperties.tokenizeDfOutput(" + pos + ")");
        String buffer = null;
        StringTokenizer st = null;
        String token = null;
        try {
            FileReader tfr = new FileReader(this.tempFile);
            BufferedReader tbr = new BufferedReader(tfr);
            while ((buffer = tbr.readLine()) != null) {
                if (!buffer.endsWith(this.mountPoint)) continue;
                st = new StringTokenizer(buffer);
                break;
            }
            for (int i = 0; i < pos; ++i) {
                token = st.nextToken();
            }
            tfr.close();
        }
        catch (IOException exc) {
            Trace.trace(TRACE_MASKF, "MediaProperties.tokenizeDfOutput(): " + exc.getMessage());
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 617, mdexc).log();
        }
        Trace.trace(TRACE_MASKT, "<- MediaProperties.tokenizeDfOutput()");
        return token;
    }

    private void invokeDf() {
        Trace.trace(TRACE_MASKT, "-> MediaProperties.invokeDf()");
        try {
            File temp = new File(this.tempFile);
            if (temp.exists()) {
                temp.delete();
            }
            String[] dfCmd = new String[]{this.mediaServicesParameters.getParm(DFSCRIPT), this.tempFile, this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log")};
            Trace.trace(TRACE_MASKF, "MediaProperties.invokeDf(): dfCmd[0] = " + dfCmd[0]);
            Trace.trace(TRACE_MASKF, "MediaProperties.invokeDf(): dfCmd[1] = " + dfCmd[1]);
            Trace.trace(TRACE_MASKF, "MediaProperties.invokeDf(): dfCmd[2] = " + dfCmd[2]);
            int rc = RootProcess.executeProgram(dfCmd);
            Trace.trace(TRACE_MASKF, "MediaProperties.invokeDf(): rc = " + rc);
            if (rc != 0) {
                throw new MediaDeviceException("df command failed");
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 618, mdexc).log();
        }
        Trace.trace(TRACE_MASKT, "<- MediaProperties.invokeDf()");
    }
}

